using System;
using System.Collections.Generic;
using System.Globalization;

class Program
{
    struct Point
    {
        public double x, y;
    }

    class DSU
    {
        int[] parent, rank;
        public DSU(int n)
        {
            parent = new int[n];
            rank = new int[n];
            for (int i = 0; i < n; i++) parent[i] = i;
        }
        public int Find(int x)
        {
            if (parent[x] != x)
                parent[x] = Find(parent[x]);
            return parent[x];
        }
        public void Union(int a, int b)
        {
            a = Find(a);
            b = Find(b);
            if (a == b) return;
            if (rank[a] < rank[b]) parent[a] = b;
            else
            {
                parent[b] = a;
                if (rank[a] == rank[b]) rank[a]++;
            }
        }
    }

    static double Manhattan(Point a, Point b)
    {
        return Math.Abs(a.x - b.x) + Math.Abs(a.y - b.y);
    }

    static void Main()
    {
        CultureInfo.CurrentCulture = CultureInfo.InvariantCulture;

        var first = Console.ReadLine().Split();
        int n = int.Parse(first[0]);
        double eps = double.Parse(first[1]);

        Point[] p = new Point[n];
        for (int i = 0; i < n; i++)
        {
            var s = Console.ReadLine().Split();
            p[i] = new Point
            {
                x = double.Parse(s[0]),
                y = double.Parse(s[1])
            };
        }

        bool[] used = new bool[n];
        double[] minDist = new double[n];
        int[] parent = new int[n];

        for (int i = 0; i < n; i++)
        {
            minDist[i] = double.MaxValue;
            parent[i] = -1;
        }

        minDist[0] = 0;

        List<(int, int, double)> mstEdges = new List<(int, int, double)>();

        for (int it = 0; it < n; it++)
        {
            int v = -1;
            for (int i = 0; i < n; i++)
                if (!used[i] && (v == -1 || minDist[i] < minDist[v]))
                    v = i;

            used[v] = true;

            if (parent[v] != -1)
                mstEdges.Add((parent[v], v, minDist[v]));

            for (int u = 0; u < n; u++)
            {
                if (!used[u])
                {
                    double d = Manhattan(p[v], p[u]);
                    if (d < minDist[u])
                    {
                        minDist[u] = d;
                        parent[u] = v;
                    }
                }
            }
        }

        DSU dsu = new DSU(n);
        foreach (var e in mstEdges)
        {
            if (e.Item3 <= eps)
                dsu.Union(e.Item1, e.Item2);
        }

        Dictionary<int, int> repIndex = new Dictionary<int, int>();
        List<int> reps = new List<int>();

        for (int i = 0; i < n; i++)
        {
            int r = dsu.Find(i);
            if (!repIndex.ContainsKey(r))
            {
                repIndex[r] = i;
                reps.Add(i);
            }
        }

        int k = reps.Count;

        Console.WriteLine(k);
        for (int i = 0; i < k; i++)
        {
            if (i > 0) Console.Write(" ");
            Console.Write(reps[i] + 1);
        }
        Console.WriteLine();

        for (int i = 1; i < k; i++)
        {
            Console.WriteLine($"{reps[0] + 1} {reps[i] + 1}");
        }
    }
}